//
//  cffIndexes.h
//  GSFontTools
//
//  Created by Georg Seifert on 01.08.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
@class GSXMLWriter;
@class CFFPrivateDict;
@class CFFIndexedStrings;
@class GSFileData;
@class CFFFDArrayIndex;
@class CFFFDSelect;

@interface CFFIndex : NSObject {
	NSMutableArray *_items;
	NSMutableArray *_offsets;
	GSFileData *_file;
	NSUInteger _count;
	NSUInteger _offsetBase;
}

@property (readonly, nonatomic) NSMutableArray *items;

- (id)initWithFile:(GSFileData *)File isCFF2:(BOOL)isCFF2;

- (Class)compilerClass;

- (NSUInteger)count;

- (id)objectAtIndex:(NSUInteger)aIndex;

- (id)produceItem:(NSUInteger)i /*data:(NSData*)Data*/ file:(GSFileData *)File offset:(NSUInteger)offset size:(NSUInteger)size;

//- (id)produceItem:(NSUInteger)i data:(NSData*)Data file:(GSFileData*)File offset:(NSUInteger)offset size:(NSUInteger)size;

//- (id)produceItem:(NSUInteger)i data:(GSFileData*)File offset:(NSUInteger)offset size:(NSUInteger)size;

- (void)addObject:(id)Item;

- (void)toXML:(GSXMLWriter *)Writer;

- (void)fromXML:(NSString *)name attrs:(NSDictionary *)attrs content:(id)content;
@end

@interface CFFGlobalSubrsIndex : CFFIndex {
	CFFGlobalSubrsIndex *_globalSubrs;
	CFFPrivateDict *_private;
	CFFFDSelect *_fdSelect;
	CFFFDArrayIndex *_fdArray;
}

@property (retain, nonatomic) CFFGlobalSubrsIndex *globalSubrs;

- (id)initWithFile:(GSFileData *)File globalSubrs:(CFFGlobalSubrsIndex *)GlobalSubrs private:(CFFPrivateDict *)Private fdSelect:(CFFFDSelect *)FdSelect fdArray:(CFFFDArrayIndex *)FdArray;

- (id)selectorAtIndex:(NSUInteger)aIndex;
@end

@interface CFFTopDictIndex : CFFIndex {
	CFFIndexedStrings *_strings;
	CFFGlobalSubrsIndex *_globalSubrs;
}

@property (retain, nonatomic) CFFIndexedStrings *strings;

@property (retain, nonatomic) CFFGlobalSubrsIndex *globalSubrs;
@end

@interface CFFFDArrayIndex : CFFTopDictIndex
@end

@interface CFFSubrsIndex : CFFGlobalSubrsIndex
@end
